<?php
/*
 * Created on 05. Feb. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: SimpleTextDocument.php 254 2007-08-01 14:14:30Z nmarkgraf $
 */
require_once 'OpenDocumentPHP/OpenDocumentText.php';
/**
 * Sample: A simple OpenDocument Text.
 * 
 * You can call this PHP file via command line like this:
 * 
 * <code>
 *  :> php SimpleTextDocument myfirstdoc.odt
 * </code>
 * 
 * After that you should have a new OpenDocument text document named myfirstdoc.odt in
 * the current directory.
 * 
 * 
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license		http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version		$Revision: 254 $
 * @package		OpenDocumentPHP
 * @subpackage 	samples
 * @since 		0.5.0 - 08. Feb. 2007
 */

/*
 * replace the first '' with a path of your choice or the full path in $fullpath.
 */
$fullpath = tempnam('', 'SDC');

/*
 * if a parameter was given, than use this parameter as filename. 
 */
if ($argc == 2) {
	$fullpath = $argv[1];
}

/*
 * If demo output exists, remove it first.
 */
if (file_exists($fullpath . '.odt')) {
    unlink($fullpath . '.odt');
}

/*
 * Open a new OpenDocumentText object with filename "$fullpath".'odt'.
 */
$text = new OpenDocumentText($fullpath . '.odt');
/* ------------- */
/* Set meta data */
/* ------------- */
$text->setDefaultMeta();
/* --------------------------- */
/*  Set Font Face Declarations */
/* --------------------------- */
$text->setDefaultFontFaces();
/* ------------------ */
/* Set up some styles */
/* ------------------ */
$text->setDefaultStyles();
/* --------------------- */
/* Write some Paragraphs */
/* --------------------- */
$textbody = $text->getBody()->getTextFragment();

// First we create a headline:

$heading = $textbody->nextHeading();
$heading->setStyleName('Heading_20_1');
$heading->append('Headline');

// Now we write a short paragraph:
$paragraph = $textbody->nextParagraph();
$paragraph->setStyleName('Standard');
$paragraph->append('The first paragraph in the document. ');
$paragraph->append('And this is the 2nd part of this first paragraph.');

// *** FIX ME *** - We should do a lot of other work here...

$text->close();

/*
 * remove tmp file if there is one ...
 */
if (file_exists($fullpath)) {
    unlink($fullpath);
}

echo "You can find the new simple OpenDocument file here: " . $fullpath . "\n";
?>
